
if ~exist('totccell','var')
	hiscale_sizeVcarbonabs();
end


colorlist = [...
	0.0,0.0,0.8;...	% Apr 28
	0.8,0.0,0.0;...	% May 05
	0.0,0.5,0.0;...	% May 14
	0.6,0.6,0.6];	% May 02
	

figure; hold on;
maxfig(gcf,1);

%% Plotting Markers
plot(sizecell{1},totccell{1},'LineStyle','none','Marker','s','MarkerSize',12,'Color',colorlist(1,:)); %apr 28 medium SP
plot(sizecell{4},totccell{4},'LineStyle','none','Marker','x','MarkerSize',12,'Color',colorlist(4,:)); %may 02 low SP
plot(sizecell{2},totccell{2},'LineStyle','none','Marker','.','MarkerSize',20,'Color',colorlist(2,:)); %may 05 high SP
plot(sizecell{3},totccell{3},'LineStyle','none','Marker','o','MarkerSize',8,'Color',colorlist(3,:)); %may 14 ASOPs?

%% Plotting Patch Regions
patchx_fop = [0, 1.8, 1.8, 0];
patchy_fop = [0.02, 0.29, 0.47, 0.07];
patch(patchx_fop,patchy_fop,'b','FaceAlpha',0.2,'LineStyle','none');

patchx_soa = [0, 1.8, 1.8, 0];
patchy_soa = [0.02, 0.025, 0.16, 0.07];
patch(patchx_soa,patchy_soa,'k','FaceAlpha',0.2,'LineStyle','none');


%% Plotting Guidelines
fitnames = {'Apr28','May02','May05','May14'};
linexvals = linspace(0,1.5,10);

%%%% Using fitlm and fixing 0,0
for i = 1:4
	fitvals.(fitnames{i}) = fitlm(sizecell{i},totccell{i},'Intercept',false);
	lineyvals(i,:) = fitvals.(fitnames{i}).Coefficients.Estimate(1).*linexvals;% + fitvals.(fitnames{i}).Coefficients.Estimate(1);
	plot(linexvals,lineyvals(i,:),'Color',colorlist(i,:),'LineWidth',3);
end

%%%% Using polyfit
% for i = 1:4
% 	fitvals(i,:) = polyfit(sizecell{i},totccell{i}',1);
% 	lineyvals(i,:) = fitvals(i,1).*linexvals + fitvals(i,2);
% 	plot(linexvals,lineyvals(i,:),'Color',colorlist(i,:),'LineWidth',3);
% end

legend({'Apr 28','May 02','May 05','May 14','Field organic particles','Lab-generated SOA'},'Box','on','Location','northwest');


xlim([0,1.5]);
ylim([0,1.5]);
set(gca,'YTick',[0.15, 0.3, 0.45, 0.6, 0.75, 0.9, 1.05, 1.2, 1.35],...
	'YTickLabel',{[],'0.3',[],'0.6',[],'0.9',[],'1.2',[]});
set(gca,'XTick',[0, 0.15, 0.3, 0.45, 0.6, 0.75, 0.9, 1.05, 1.2, 1.35, 1.5, 1.65, 1.8],...
	'XTickLabel',{0, [],'0.3',[],'0.6',[],'0.9',[],'1.2',[], '1.5', [], '1.8'});
set(gca,'FontWeight','bold','FontSize',25,'Color','none');
xlabel('Circular equivalent diameter (\mum)');
ylabel('Total carbon absorption (arb.)');
axis square
